/*
 * Decompiled with CFR 0.152.
 */
package jace.config;

import jace.config.Configuration;
import jace.config.StringComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

class FileComponent
extends JPanel
implements ActionListener,
KeyListener {
    Configuration.ConfigNode node;
    String fieldName;
    private int TEXT_FIELD_WIDTH = 150;
    private String extensionFilter;
    private String fileTypeName;
    private int fileSelectionMode = 0;
    private JButton browseButton;
    private JTextField textField;

    @Override
    public void actionPerformed(ActionEvent e) {
        this.textField.setBackground(Color.WHITE);
        String value = this.textField.getText();
        if (value == null || value.equals("")) {
            this.node.setFieldValue(this.fieldName, null);
        } else {
            File f = new File(value);
            if (f.exists()) {
                this.node.setFieldValue(this.fieldName, f);
            } else {
                this.textField.setBackground(Color.RED);
            }
        }
    }

    public void synchronizeValue() {
        try {
            Serializable value = this.node.getFieldValue(this.fieldName);
            if (value == null) {
                this.setText("");
            } else {
                this.setText(String.valueOf(value));
            }
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(StringComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public FileComponent(Configuration.ConfigNode node, String fieldName) {
        this.node = node;
        this.fieldName = fieldName;
        this.initComponents();
        this.textField.addActionListener(this);
        this.synchronizeValue();
    }

    private void initComponents() {
        this.textField = new JTextField();
        this.browseButton = new JButton();
        this.textField.setPreferredSize(new Dimension(150, 20));
        this.textField.addKeyListener(this);
        this.browseButton.setText("...");
        this.browseButton.setPreferredSize(new Dimension(25, 20));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileComponent.this.browseButtonActionPerformed(evt);
            }
        });
        this.add(this.textField);
        this.add(this.browseButton);
        FlowLayout layout = new FlowLayout();
        this.setLayout(layout);
        this.validate();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File currentDirectory = new File(".");
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(this.fileSelectionMode);
        if (this.extensionFilter != null && this.fileTypeName != null) {
            FileFilter filter = new FileFilter(){
                String[] extensions;
                {
                    this.extensions = FileComponent.this.extensionFilter.toLowerCase().split(",");
                }

                @Override
                public boolean accept(File f) {
                    for (int i = 0; i < this.extensions.length; ++i) {
                        if (!f.getPath().toLowerCase().endsWith(this.extensions[i])) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    return FileComponent.this.fileTypeName;
                }
            };
            chooser.setFileFilter(filter);
        }
        try {
            File f = new File(this.textField.getText());
            if (f.exists()) {
                if (f.isDirectory()) {
                    chooser.setCurrentDirectory(f);
                } else {
                    chooser.setCurrentDirectory(f.getParentFile());
                    chooser.setSelectedFile(f);
                }
            } else {
                chooser.setCurrentDirectory(currentDirectory);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                File selectedFile = chooser.getSelectedFile();
                if (selectedFile.getCanonicalPath().startsWith(currentDirectory.getCanonicalPath())) {
                    String use = selectedFile.getCanonicalPath().substring(currentDirectory.getCanonicalPath().length() + 1);
                    this.textField.setText(use);
                } else {
                    this.textField.setText(selectedFile.getPath());
                }
                this.node.setFieldValue(this.fieldName, selectedFile);
            }
            catch (IOException ex) {
                Logger.getLogger(FileComponent.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public String getText() {
        return this.textField.getText();
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    public String getExtensionFilter() {
        return this.extensionFilter;
    }

    public void setExtensionFilter(String extensionFilter) {
        this.extensionFilter = extensionFilter;
    }

    public String getFileTypeName() {
        return this.fileTypeName;
    }

    public void setFileTypeName(String fileTypeName) {
        this.fileTypeName = fileTypeName;
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        this.fileSelectionMode = fileSelectionMode;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.actionPerformed(null);
    }
}

